;------------------------------------------------------------------------------
;---	VL: VCPU Loader V1
;---	©2024.08.19.+ by B.
;---	Standalone fastloader for SD2IEC+VCPU
;---	*** Drivecode ***
;------------------------------------------------------------------------------
	INCLUDE "def6502.asm"
	INCLUDE "vcpumacros-asl.asm"
;------------------------------------------------------------------------------
drivecode_addr	=	$0200
;------------------------------------------------------------------------------
;---	sd2iec VCPU drivecode:
;---	WARNING: no stack in use, so no SPH:SP is initialized

	ORG	drivecode_addr-4
_drivecode_start
;	Mem-write "header":
		BYT	"ZW"
		ADR	drivecode_addr
;	Mem-write "header" end.

;	Drivecode:
		lda	#0				;Channel #0
		break	vcpu_syscall_getchannelparams
		cpy	#$ff				;Any error?
		beq	.errorremain

		tyzph

		ucldh					;CLK Low (BUSY...!), DAT release
		uwdtl					;Wait for DAT low (sync)

.loadcycle	ldx	vcpu_param_lastused
		txa
		sec
		sbc	vcpu_param_position		;end-start = no. of BYTEs
		tay

		iny
		tya					;No. of BYTEs
		dey

		eor	#$ff
		usnd1					;Send BYTE-no to host
.blockcyc	lda	$00,x				;Data from block
		eor	#$ff
		usnd1					;Send to host
		udedb	.blockcyc			;go to send cycle
		uwckh					;Wait for CLK high (host accept last bit)
		usckl					;CLK = Low: BUSY

		lda	vcpu_param_eoi			;End of file?
		bne	.endoffile
		lda	#0				;Channel #0
		break	vcpu_syscall_refillbuffer	;Read next block
		cpy	#$ff				;Error?
		bne	.loadcycle
.errorremain	break	vcpu_syscall_exit_remain	;If error, exit...

.endoffile	lda	#$ff!$ff			;No. of BYTEs = $FF: End of file
		usnd1					;Send to host
		uwckh					;Wait for CLK high (host accept last bit)
		break	vcpu_syscall_exit_ok		;Exit
_drivecode_end

;---	Drivecode starter string:
_drivestarter_start
		BYT	"ZE"
		ADR	drivecode_addr
_drivestarter_end

;------------------------------------------------------------------------------
	SHARED	_drivecode_start
	SHARED	_drivecode_end
	SHARED	_drivestarter_start
	SHARED	_drivestarter_end
;------------------------------------------------------------------------------
