;------------------------------------------------------------------------------
;---	VL: VCPU Loader V1
;---	©2024.08.19.+ by B.
;---	Standalone fastloader for sd2iec+vcpu
;---	1 bit synchronozed transfer
;---	©2025.12.30.: V0.3
;------------------------------------------------------------------------------
	INCLUDE "def6502.asm"
	INCLUDE "defines.asm"
	INCLUDE	"drivecode.inc"
	INCLUDE	"_actdate.inc"		;Generated automatically
;------------------------------------------------------------------------------
def_version	=	"0.3"
resident1_addr	=	$05f5
resident1_maxe	=	$06eb
resident2_addr	=	$05a7+9
resident2_maxe	=	$05e6
resident3_addr	=	$0140+$8	;+8 for CBM FILEBROWSER BASIC loader
					;  (this stuff POKE a small asm code to $0140)
;------------------------------------------------------------------------------
	INCLUDE "header.asm"		;Include BASIC header
;------------------------------------------------------------------------------
;	Copy resident (including drivecode) to lower memory areas:
		ldx	#_resident1_end-_resident1_start
-		lda	_resident1_start-1,x
		sta	resident1_addr-1,x
		dex
		bne	-

		ldx	#_resident2_end-_resident2_start
-		lda	_resident2_start-1,x
		sta	resident2_addr-1,x
		dex
		bne	-

		ldx	#_resident3_end-_resident3_start
-		lda	_resident3_start-1,x
		sta	resident3_addr-1,x
		dex
		bne	-

;	Set LOAD vector:
		lda	#lo(fastloader)
		sta	_iload+0
		lda	#hi(fastloader)
		sta	_iload+1

		jsr	rom_primm
		BYT	ascii_return,"VL1S V",def_version
    IFNDEF autoload_filebrowser
		BYT	ascii_return,"SD2IEC VCPU FASTLOADER (1S) BY B."
		BYT	ascii_return,"(C)",__date_ys__,"-"
      IF __date_mn__ = 1
		BYT	"JAN"
      ELSEIF __date_mn__ = 2
		BYT	"FEB"
      ELSEIF __date_mn__ = 3
		BYT	"MAR"
      ELSEIF __date_mn__ = 4
		BYT	"APR"
      ELSEIF __date_mn__ = 5
		BYT	"MAY"
      ELSEIF __date_mn__ = 6
		BYT	"JUN"
      ELSEIF __date_mn__ = 7
		BYT	"JUL"
      ELSEIF __date_mn__ = 8
		BYT	"AUG"
      ELSEIF __date_mn__ = 9
		BYT	"SEP"
      ELSEIF __date_mn__ = 10
		BYT	"OCT"
      ELSEIF __date_mn__ = 11
		BYT	"NOV"
      ELSEIF __date_mn__ = 12
		BYT	"DEC"
      ELSE
	ERROR "Date Error!"
      ENDIF
		BYT	"-",__date_ds__,".",ascii_return,0
    ELSE
		BYT	" / ",__date_ys__,"-",__date_ms__,"-",__date_ds__
		BYT	ascii_return,ascii_return
		BYT	ascii_return,ascii_return,"DLOAD",$22,"FB16*",$22,ascii_esc,"Q"
		BYT	ascii_return,ascii_return,ascii_return,ascii_return,ascii_return
		BYT	ascii_up,ascii_up,ascii_up,ascii_up,ascii_up,ascii_up,ascii_up,ascii_up
		BYT	0

		ldx	#((++)-(+))-1
-		lda	+,x
		sta	_keyd,x
		dex
		bpl	-
		lda	#((++)-(+))
		sta	z_ndx
    ENDIF
		jsr	bas_vectorsinit		;BASIC vectors init
		jsr	bas_reset		;BASIC interpreter reset
		;lda	z_txttab+0
		;ldy	z_txttab+1
		;jsr	bas_memorycheck		;Check and set free memory
		jsr	bas_printfree		;Print "xxx BYTES FREE" message
		cli
		jmp	bas_coldreset_c

    IFDEF autoload_filebrowser
+		BYT	ascii_return,"RUN",ascii_esc,"Q",ascii_return
+
    ENDIF
;------------------------------------------------------------------------------
;---	Resident LOAD routine:

_resident1_start
    PHASE resident1_addr
		rts				;3-PLUS-1 starter code: no function

fastloader	sta	z_verfck		;verify flag
		tax				;Load or Verify?
		bne	.verify
		lda	z_fa			;Unit no
		cmp	#8			;Drive..?
		bcs	.driveload
.verify		jmp	rom_loadcont		;If no drive / verify, go ROM's LOAD

.filenotfound	jmp	rom_err_filenf		;"FILE NOT FOUND"

.driveload	ldy	z_fnlen			;Filename len
		beq	.verify

		ldx	z_sa			;Secondary address
		jsr	rom_srchingfor		;"SEARCHING FOR..."
		lda	#$60
		sta	z_sa			;"Real" secondary address: channel #0 set
		jsr	rom_busop		;Bus OPEN
		lda	z_fa			;Unit no
		jsr	rom_talk		;Talk
		lda	z_sa
		jsr	rom_tksa		;Secondary Talk
		jsr	rom_acptr		;Read data (load address Lo)
		sta	z_eal
		lda	z_status
		lsr	a
		lsr	a
		bcs	.filenotfound
		jsr	rom_acptr		;Read data (load address Hi)
		sta	z_eah
		txa				;Load secondary address
		bne	.origldaddr
		lda	z_memuss+0
		sta	z_eal
		lda	z_memuss+1
		sta	z_eah
.origldaddr
		jsr	rom_loadvfying		;"LOADING"
		lda	z_eah
		cmp	#hi($0800)
		bcs	.addrokay
		jsr	rom_restor		;Restore vectors
		jmp	rom_loadcont2		;KERNAL LOAD

;	Load address >= $0800: fastload:
.addrokay	jsr	rom_untlk		;UnTalk
		jsr	downloader		;Download and start drivecode

		ldx	#255
.waitstart	dex
		bne	.contwait
		jmp	rom_loadcont		;Drivecode not start (maybe no VCPU support, or no SD2IEC drive), go ROM load
.contwait	bit	$01			;CLK low? Drivecode started?
		bvs	.waitstart		;If CLK high, wait...
		inc	$01
		dec	$01			;DAT line Low+Release: ACK pulse to drive

		lda	z_eal
		bne	.ncy1
		dec	z_eah
.ncy1		dec	z_eal			;-1 ($zp),y : Y !=0

		sei
.loadcycle	ldx	$ff19
.waitready	stx	$ff19			;"Simpler" wait indicator
		bit	$01			;DAT=N, CLK=V
		bvc	.waitready		;If CLK Low, wait READY...
		jsr	receive_byte		;Get BYTE from drive: No. of BYTEs
		beq	.deviceerror		;No. of bytes = 0? (8 high bits received)
		cmp	#$ff			;=255? File end?
		bne	.recvnext		;If <>0, (maybe) new block
;	File end:
		inc	z_eal
		bne	.ncy3
		inc	z_eah
.ncy3
		clc
		BYT	$24			;BIT $zp Op.Code
.deviceerror	sec				;ERROR
		lda	#%00011011
		sta	$ff06			;Screen back On
		cli
		bcs	.loaderrex
		jmp	rom_loadcontend
.loaderrex	lda	#$1d			;"LOAD ERROR"
		rts

;	Next block ready, accept:
.recvnext	pha				;Save block size
		tay
		cmp	#254			;Full block receive?
		bne	.notfullblock
		lda	#%00001011
		sta	$ff06			;Screen Off
.notfullblock	lda	#$a4			;LDY $xx Op.Code
		sta	receive_byte.offset	;Recv. cycle restored
		jsr	receive_byte		;Get all bytes from block
		lda	#$60			;RTS Op.Code
		sta	receive_byte.offset	;Switch back to one BYTE receiver
		pla				;Restore block size
		clc
		adc	z_eal
		sta	z_eal
		bcc	.loadcycle
		inc	z_eah
		bne	.loadcycle		;~BRA, get next block

;---	Download and start drivecode:
downloader	ldy	#_drivecode_start-_drivecode_start	;Start offset
		lda	#_drivecode_end-_drivecode_start	;End offset
		jsr	.sendtodrive

		ldy	#_drivestarter_start-_drivecode_start	;Start offset
		lda	#_drivestarter_end-_drivecode_start	;End offset

.sendtodrive	sta	.endpos+1		;Set end position
		lda	#$00
		sta	z_status
		lda	z_fa			;Unit no
		jsr	rom_listn
		lda	#$6f
		jsr	rom_secnd
.sendcyc	lda	resident3_addr,y
		jsr	rom_ciout
		iny
.endpos		cpy	#$00			;<- modified
		bne	.sendcyc
		jmp	rom_unlsn		;UnListen

      IF * > resident1_maxe
        ERROR "End address too big!"
      ENDIF

    DEPHASE
_resident1_end



_resident2_start
    PHASE resident2_addr
;---	BYTE and BLOCK receive routine:
receive_byte	ldx	#%11001000		;CLK (+DAT+ATN) HiZ
.byterecvcycle	sty	z_dcount
		ldy	#%01101010		;CLK Low, plus B7/B6/B5 trim to compare
		cpy	$01
		sty	$01
		ror	a
		cpy	$01
		stx	$01
		ror	a
		cpy	$01
		sty	$01
		ror	a
		cpy	$01
		stx	$01
		ror	a
		cpy	$01
		sty	$01
		ror	a
		cpy	$01
		stx	$01
		ror	a
		cpy	$01
		sty	$01
		ror	a
		cpy	$01
		stx	$01
		ror	a

.offset	;	ldy	z_dcount		;A4 AA    LDY $AA

		rts
		BYT	z_dcount		;         2 BYTE, LDY $AA

		sta	(z_eal),y		;91 9D    STA (z_eal),y
		dey
		bne	.byterecvcycle
		rts

      IF * > resident2_maxe
        ERROR "End address too big!"
      ENDIF

    DEPHASE
_resident2_end
;------------------------------------------------------------------------------
;---	SD2IEC VCPU drivecode
_resident3_start
	BINCLUDE "drivecode.bin"
_resident3_end
;------------------------------------------------------------------------------
